import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { SNNote } from '../Note/Note';
interface EditorContent extends ItemContent {
    notes: SNNote[];
    data: Record<string, unknown>;
    url: string;
    name: string;
    default: boolean;
    systemEditor: boolean;
}
/**
 * @deprecated
 * Editor objects are depracated in favor of SNComponent objects
 */
export declare class SNEditor extends DecryptedItem<EditorContent> {
    readonly notes: SNNote[];
    readonly data: Record<string, unknown>;
    readonly url: string;
    readonly name: string;
    readonly isDefault: boolean;
    readonly systemEditor: boolean;
    constructor(payload: DecryptedPayloadInterface<EditorContent>);
}
export {};
