import { Uuid } from '@standardnotes/common';
import { FeatureIdentifier, ThirdPartyFeatureDescription, ComponentArea, ComponentPermission, NoteType } from '@standardnotes/features';
import { ComponentContent, ComponentInterface } from './ComponentContent';
import { ConflictStrategy } from '../../Abstract/Item/Types/ConflictStrategy';
import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { HistoryEntryInterface } from '../../Runtime/History';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { Predicate } from '../../Runtime/Predicate/Predicate';
import { ItemInterface } from '../../Abstract/Item/Interfaces/ItemInterface';
import { DecryptedItemInterface } from './../../Abstract/Item/Interfaces/DecryptedItem';
import { ComponentPackageInfo } from './PackageInfo';
export declare const isComponent: (x: ItemInterface) => x is SNComponent;
export declare const isComponentOrTheme: (x: ItemInterface) => x is SNComponent;
/**
 * Components are mostly iframe based extensions that communicate with the SN parent
 * via the postMessage API. However, a theme can also be a component, which is activated
 * only by its url.
 */
export declare class SNComponent extends DecryptedItem<ComponentContent> implements ComponentInterface {
    readonly componentData: Record<string, unknown>;
    /** Items that have requested a component to be disabled in its context */
    readonly disassociatedItemIds: string[];
    /** Items that have requested a component to be enabled in its context */
    readonly associatedItemIds: string[];
    readonly local_url?: string;
    readonly hosted_url?: string;
    readonly offlineOnly: boolean;
    readonly name: string;
    readonly autoupdateDisabled: boolean;
    readonly package_info: ComponentPackageInfo;
    readonly area: ComponentArea;
    readonly permissions: ComponentPermission[];
    readonly valid_until: Date;
    readonly active: boolean;
    readonly legacy_url?: string;
    readonly isMobileDefault: boolean;
    constructor(payload: DecryptedPayloadInterface<ComponentContent>);
    /** Do not duplicate components under most circumstances. Always keep original */
    strategyWhenConflictingWithItem(_item: DecryptedItemInterface, _previousRevision?: HistoryEntryInterface): ConflictStrategy;
    get isSingleton(): boolean;
    get displayName(): string;
    singletonPredicate(): Predicate<SNComponent>;
    isEditor(): boolean;
    isTheme(): boolean;
    isDefaultEditor(): boolean;
    getLastSize(): unknown;
    /**
     * The key used to look up data that this component may have saved to an item.
     * This data will be stored on the item using this key.
     */
    getClientDataKey(): string;
    hasValidHostedUrl(): boolean;
    contentKeysToIgnoreWhenCheckingEquality(): (keyof ItemContent)[];
    /**
     * An associative component depends on being explicitly activated for a
     * given item, compared to a dissaciative component, which is enabled by
     * default in areas unrelated to a certain item.
     */
    static associativeAreas(): ComponentArea[];
    isAssociative(): boolean;
    isExplicitlyEnabledForItem(uuid: Uuid): boolean;
    isExplicitlyDisabledForItem(uuid: Uuid): boolean;
    get isExpired(): boolean;
    get identifier(): FeatureIdentifier;
    get thirdPartyPackageInfo(): ThirdPartyFeatureDescription;
    get noteType(): NoteType;
    get isDeprecated(): boolean;
    get deprecationMessage(): string | undefined;
}
