export declare enum ActionAccessType {
    Encrypted = "encrypted",
    Decrypted = "decrypted"
}
export declare enum ActionVerb {
    Get = "get",
    Render = "render",
    Show = "show",
    Post = "post",
    Nested = "nested"
}
export declare type Action = {
    label: string;
    desc: string;
    running?: boolean;
    error?: boolean;
    lastExecuted?: Date;
    context?: string;
    verb: ActionVerb;
    url: string;
    access_type: ActionAccessType;
    subactions?: Action[];
};
