import { DecryptedItemInterface } from './../../Abstract/Item/Interfaces/DecryptedItem';
import { ThirdPartyFeatureDescription } from '@standardnotes/features';
import { DecryptedItem } from '../../Abstract/Item/Implementations/DecryptedItem';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { ConflictStrategy } from '../../Abstract/Item/Types/ConflictStrategy';
import { DecryptedPayloadInterface } from '../../Abstract/Payload/Interfaces/DecryptedPayload';
import { HistoryEntryInterface } from '../../Runtime/History/HistoryEntryInterface';
import { Action } from './Types';
import { ComponentPackageInfo } from '../Component/PackageInfo';
export interface ActionExtensionInterface {
    actions: Action[];
    deprecation?: string;
    description: string;
    hosted_url?: string;
    name: string;
    package_info: ComponentPackageInfo;
    supported_types: string[];
    url: string;
}
export declare type ActionExtensionContent = ActionExtensionInterface & ItemContent;
/**
 * Related to the SNActionsService and the local Action model.
 */
export declare class SNActionsExtension extends DecryptedItem<ActionExtensionContent> {
    readonly actions: Action[];
    readonly description: string;
    readonly url: string;
    readonly supported_types: string[];
    readonly deprecation?: string;
    readonly name: string;
    readonly package_info: ComponentPackageInfo;
    constructor(payload: DecryptedPayloadInterface<ActionExtensionContent>);
    get displayName(): string;
    get thirdPartyPackageInfo(): ThirdPartyFeatureDescription;
    get isListedExtension(): boolean;
    actionsWithContextForItem(item: DecryptedItemInterface): Action[];
    /** Do not duplicate. Always keep original */
    strategyWhenConflictingWithItem(_item: DecryptedItemInterface, _previousRevision?: HistoryEntryInterface): ConflictStrategy;
}
