import { PredicateTarget, PredicateInterface, PredicateJsonForm, PredicateOperator, StringKey, SureValue } from './Interface';
/**
 * A local-only construct that defines a built query that
 * can be used to dynamically search items.
 */
export declare class Predicate<T extends PredicateTarget> implements PredicateInterface<T> {
    readonly keypath: StringKey<T>;
    readonly operator: PredicateOperator;
    readonly targetValue: SureValue;
    constructor(keypath: StringKey<T>, operator: PredicateOperator, targetValue: SureValue);
    keypathIncludesString(verb: string): boolean;
    matchesItem<T extends PredicateTarget>(item: T): boolean;
    toJson(): PredicateJsonForm;
}
