export interface PredicateInterface<T> {
    matchesItem(item: T): boolean;
    keypathIncludesString(verb: string): boolean;
    toJson(): PredicateJsonForm;
}
export declare type RawPredicateInArrayForm = string[];
export interface PredicateJsonForm {
    keypath?: string;
    operator: PredicateOperator;
    value: SureValue | PredicateJsonForm | PredicateJsonForm[] | RawPredicateInArrayForm;
}
export declare const AllPredicateCompoundOperators: readonly ["and", "or"];
export declare type PredicateCompoundOperator = typeof AllPredicateCompoundOperators[number];
export declare const AllPredicateOperators: readonly ["and", "or", "!=", "=", "<", ">", "<=", ">=", "startsWith", "in", "matches", "not", "includes"];
export declare type PredicateOperator = typeof AllPredicateOperators[number];
export declare type SureValue = number | number[] | string[] | string | Date | boolean | false | '';
export declare const SureValueNonObjectTypesAsStrings: string[];
export declare type FalseyValue = false | '' | null | undefined;
export declare type PrimitiveOperand = SureValue | FalseyValue;
export declare type PredicateTarget = unknown;
export declare type StringKey<T = unknown> = keyof T & string;
