"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHistoryEntryForPayload = void 0;
const common_1 = require("@standardnotes/common");
const HistoryEntry_1 = require("./HistoryEntry");
const NoteHistoryEntry_1 = require("./NoteHistoryEntry");
function CreateHistoryEntryForPayload(payload, previousEntry) {
    const type = payload.content_type;
    const historyItemClass = historyClassForContentType(type);
    const entry = new historyItemClass(payload, previousEntry);
    return entry;
}
exports.CreateHistoryEntryForPayload = CreateHistoryEntryForPayload;
function historyClassForContentType(contentType) {
    switch (contentType) {
        case common_1.ContentType.Note:
            return NoteHistoryEntry_1.NoteHistoryEntry;
        default:
            return HistoryEntry_1.HistoryEntry;
    }
}
