import { ItemContent } from './../../../Abstract/Content/ItemContent';
import { EncryptedItemInterface } from './../../../Abstract/Item/Interfaces/EncryptedItem';
import { ContentType, Uuid } from '@standardnotes/common';
import { SNIndex } from '../../Index/SNIndex';
import { DecryptedItemInterface } from '../../../Abstract/Item/Interfaces/DecryptedItem';
import { CollectionInterface } from '../CollectionInterface';
import { DeletedItemInterface } from '../../../Abstract/Item';
import { Collection } from '../Collection';
import { AnyItemInterface } from '../../../Abstract/Item/Interfaces/UnionTypes';
import { ItemDelta } from '../../Index/ItemDelta';
export declare class ItemCollection extends Collection<AnyItemInterface, DecryptedItemInterface, EncryptedItemInterface, DeletedItemInterface> implements SNIndex, CollectionInterface {
    onChange(delta: ItemDelta): void;
    findDecrypted<T extends DecryptedItemInterface = DecryptedItemInterface>(uuid: Uuid): T | undefined;
    findAllDecrypted<T extends DecryptedItemInterface = DecryptedItemInterface>(uuids: Uuid[]): T[];
    findAllDecryptedWithBlanks<C extends ItemContent = ItemContent>(uuids: Uuid[]): (DecryptedItemInterface<C> | undefined)[];
    allDecrypted<T extends DecryptedItemInterface>(contentType: ContentType | ContentType[]): T[];
}
