import { ContentType } from '@standardnotes/common';
import { PayloadInterface } from '../Interfaces/PayloadInterface';
import { PayloadSource } from '../Types/PayloadSource';
import { TransferPayload } from '../../TransferPayload/Interfaces/TransferPayload';
import { ItemContent } from '../../Content/ItemContent';
import { SyncResolvedParams, SyncResolvedPayload } from '../../../Runtime/Deltas/Utilities/SyncResolvedPayload';
export declare abstract class PurePayload<T extends TransferPayload<C>, C extends ItemContent = ItemContent> implements PayloadInterface<T> {
    readonly source: PayloadSource;
    readonly uuid: string;
    readonly content_type: ContentType;
    readonly deleted: boolean;
    readonly content: C | string | undefined;
    readonly created_at: Date;
    readonly updated_at: Date;
    readonly created_at_timestamp: number;
    readonly updated_at_timestamp: number;
    readonly dirtyIndex?: number;
    readonly globalDirtyIndexAtLastSync?: number;
    readonly dirty?: boolean;
    readonly lastSyncBegan?: Date;
    readonly lastSyncEnd?: Date;
    readonly duplicate_of?: string;
    constructor(rawPayload: T, source?: PayloadSource);
    ejected(): TransferPayload;
    get serverUpdatedAt(): Date;
    get serverUpdatedAtTimestamp(): number;
    abstract copy(override?: Partial<TransferPayload>, source?: PayloadSource): this;
    abstract copyAsSyncResolved(override?: Partial<T> & SyncResolvedParams, source?: PayloadSource): SyncResolvedPayload;
}
