import { ProtocolVersion } from '@standardnotes/common';
import { SyncResolvedParams, SyncResolvedPayload } from '../../../Runtime/Deltas/Utilities/SyncResolvedPayload';
import { EncryptedTransferPayload } from '../../TransferPayload/Interfaces/EncryptedTransferPayload';
import { EncryptedPayloadInterface } from '../Interfaces/EncryptedPayload';
import { PayloadSource } from '../Types/PayloadSource';
import { PurePayload } from './PurePayload';
export declare class EncryptedPayload extends PurePayload<EncryptedTransferPayload> implements EncryptedPayloadInterface {
    readonly content: string;
    readonly deleted: false;
    readonly auth_hash?: string;
    readonly enc_item_key: string;
    readonly errorDecrypting: boolean;
    readonly items_key_id: string | undefined;
    readonly version: ProtocolVersion;
    readonly waitingForKey: boolean;
    constructor(rawPayload: EncryptedTransferPayload, source?: PayloadSource);
    ejected(): EncryptedTransferPayload;
    copy(override?: Partial<EncryptedTransferPayload>, source?: PayloadSource): this;
    copyAsSyncResolved(override?: Partial<EncryptedTransferPayload> & SyncResolvedParams, source?: PayloadSource): SyncResolvedPayload;
}
