import { MutationType } from '../Types/MutationType';
import { PayloadInterface } from '../../Payload';
import { ItemInterface } from '../Interfaces/ItemInterface';
import { TransferPayload } from '../../TransferPayload';
/**
 * An item mutator takes in an item, and an operation, and returns the resulting payload.
 * Subclasses of mutators can modify the content field directly, but cannot modify the payload directly.
 * All changes to the payload must occur by copying the payload and reassigning its value.
 */
export declare class ItemMutator<P extends PayloadInterface<TransferPayload> = PayloadInterface<TransferPayload>, I extends ItemInterface<P> = ItemInterface<P>> {
    readonly immutableItem: I;
    protected immutablePayload: P;
    protected readonly type: MutationType;
    constructor(item: I, type: MutationType);
    getUuid(): string;
    getItem(): I;
    getResult(): P;
    setBeginSync(began: Date, globalDirtyIndex: number): void;
    set errorDecrypting(_: boolean);
    set updated_at(_: Date);
    set updated_at_timestamp(_: number);
}
