import { DecryptedItemInterface } from './../Interfaces/DecryptedItem';
import { MutationType } from '../Types/MutationType';
import { PrefKey } from '../../../Syncable/UserPrefs/PrefKey';
import { Uuid } from '@standardnotes/common';
import { ItemContent } from '../../Content/ItemContent';
import { AppDataField } from '../Types/AppDataField';
import { DomainDataValueType, ItemDomainKey } from '../Types/DefaultAppDomain';
import { ItemMutator } from './ItemMutator';
import { DecryptedPayloadInterface } from '../../Payload/Interfaces/DecryptedPayload';
import { ItemInterface } from '../Interfaces/ItemInterface';
export declare class DecryptedItemMutator<C extends ItemContent = ItemContent> extends ItemMutator<DecryptedPayloadInterface<C>, DecryptedItemInterface<C>> {
    protected mutableContent: C;
    constructor(item: DecryptedItemInterface<C>, type: MutationType);
    getResult(): DecryptedPayloadInterface<C>;
    setBeginSync(began: Date, globalDirtyIndex: number): void;
    /** Not recommended to use as this might break item schema if used incorrectly */
    setCustomContent(content: C): void;
    set userModifiedDate(date: Date);
    set conflictOf(conflictOf: Uuid | undefined);
    set protected(isProtected: boolean);
    set trashed(trashed: boolean);
    set starred(starred: boolean);
    set pinned(pinned: boolean);
    set archived(archived: boolean);
    set locked(locked: boolean);
    /**
     * Overwrites the entirety of this domain's data with the data arg.
     */
    setDomainData(data: DomainDataValueType, domain: ItemDomainKey): void;
    /**
     * First gets the domain data for the input domain.
     * Then sets data[key] = value
     */
    setDomainDataKey(key: keyof DomainDataValueType, value: unknown, domain: ItemDomainKey): void;
    setAppDataItem(key: AppDataField | PrefKey, value: unknown): void;
    e2ePendingRefactor_addItemAsRelationship(item: DecryptedItemInterface): void;
    removeItemAsRelationship(item: ItemInterface): void;
}
