import { ContentType } from '@standardnotes/common';
import { DecryptedPayloadInterface, DeletedPayloadInterface } from '../Payload';
/**
 * The saved sync item payload represents the payload we want to map
 * when mapping saved_items from the server or local sync mechanism. We only want to map the
 * updated_at value the server returns for the item, and basically
 * nothing else.
 */
export interface OfflineSyncSavedContextualPayload {
    content_type: ContentType;
    created_at_timestamp: number;
    deleted: boolean;
    updated_at_timestamp?: number;
    updated_at: Date;
    uuid: string;
}
export declare function CreateOfflineSyncSavedPayload(fromPayload: DecryptedPayloadInterface | DeletedPayloadInterface): OfflineSyncSavedContextualPayload;
