"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.themes = void 0;
const PermissionName_1 = require("../Permission/PermissionName");
const FeatureIdentifier_1 = require("../Feature/FeatureIdentifier");
const FillThemeComponentDefaults_1 = require("./Utilities/FillThemeComponentDefaults");
const common_1 = require("@standardnotes/common");
function themes() {
    const midnight = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Midnight',
        identifier: FeatureIdentifier_1.FeatureIdentifier.MidnightTheme,
        permission_name: PermissionName_1.PermissionName.MidnightTheme,
        description: 'Elegant utilitarianism.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/midnight-with-mobile.jpg',
        isDark: true,
        dock_icon: {
            type: 'circle',
            background_color: '#086DD6',
            foreground_color: '#ffffff',
            border_color: '#086DD6',
        },
    });
    const futura = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Futura',
        identifier: FeatureIdentifier_1.FeatureIdentifier.FuturaTheme,
        permission_name: PermissionName_1.PermissionName.FuturaTheme,
        description: 'Calm and relaxed. Take some time off.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/futura-with-mobile.jpg',
        isDark: true,
        dock_icon: {
            type: 'circle',
            background_color: '#fca429',
            foreground_color: '#ffffff',
            border_color: '#fca429',
        },
    });
    const solarizedDark = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Solarized Dark',
        identifier: FeatureIdentifier_1.FeatureIdentifier.SolarizedDarkTheme,
        permission_name: PermissionName_1.PermissionName.SolarizedDarkTheme,
        description: 'The perfect theme for any time.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/solarized-dark.jpg',
        isDark: true,
        dock_icon: {
            type: 'circle',
            background_color: '#2AA198',
            foreground_color: '#ffffff',
            border_color: '#2AA198',
        },
    });
    const autobiography = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Autobiography',
        identifier: FeatureIdentifier_1.FeatureIdentifier.AutobiographyTheme,
        permission_name: PermissionName_1.PermissionName.AutobiographyTheme,
        description: 'A theme for writers and readers.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/autobiography.jpg',
        dock_icon: {
            type: 'circle',
            background_color: '#9D7441',
            foreground_color: '#ECE4DB',
            border_color: '#9D7441',
        },
    });
    const dark = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Dark',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DarkTheme,
        permission_name: PermissionName_1.PermissionName.FocusedTheme,
        description: 'For when you need to go in.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/focus-with-mobile.jpg',
        isDark: true,
        dock_icon: {
            type: 'circle',
            background_color: '#a464c2',
            foreground_color: '#ffffff',
            border_color: '#a464c2',
        },
    });
    const titanium = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Titanium',
        identifier: FeatureIdentifier_1.FeatureIdentifier.TitaniumTheme,
        permission_name: PermissionName_1.PermissionName.TitaniumTheme,
        description: 'Light on the eyes, heavy on the spirit.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/themes/titanium-with-mobile.jpg',
        dock_icon: {
            type: 'circle',
            background_color: '#6e2b9e',
            foreground_color: '#ffffff',
            border_color: '#6e2b9e',
        },
    });
    const dynamic = (0, FillThemeComponentDefaults_1.FillThemeComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Dynamic Panels',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DynamicTheme,
        permission_name: PermissionName_1.PermissionName.ThemeDynamic,
        layerable: true,
        no_mobile: true,
        description: 'A smart theme that minimizes the tags and notes panels when they are not in use.',
    });
    return [midnight, futura, solarizedDark, autobiography, dark, titanium, dynamic];
}
exports.themes = themes;
