"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serverFeatures = void 0;
const PermissionName_1 = require("../Permission/PermissionName");
const FeatureIdentifier_1 = require("../Feature/FeatureIdentifier");
const common_1 = require("@standardnotes/common");
function serverFeatures() {
    return [
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Two factor authentication',
            identifier: FeatureIdentifier_1.FeatureIdentifier.TwoFactorAuth,
            permission_name: PermissionName_1.PermissionName.TwoFactorAuth,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.ProPlan],
            name: 'Unlimited note history',
            identifier: FeatureIdentifier_1.FeatureIdentifier.NoteHistoryUnlimited,
            permission_name: PermissionName_1.PermissionName.NoteHistoryUnlimited,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan],
            name: '365 days note history',
            identifier: FeatureIdentifier_1.FeatureIdentifier.NoteHistory365Days,
            permission_name: PermissionName_1.PermissionName.NoteHistory365Days,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Email backups',
            identifier: FeatureIdentifier_1.FeatureIdentifier.DailyEmailBackup,
            permission_name: PermissionName_1.PermissionName.DailyEmailBackup,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Sign-in email alerts',
            identifier: FeatureIdentifier_1.FeatureIdentifier.SignInAlerts,
            permission_name: PermissionName_1.PermissionName.SignInAlerts,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.DailyDropboxBackup,
            permission_name: PermissionName_1.PermissionName.DailyDropboxBackup,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.DailyGDriveBackup,
            permission_name: PermissionName_1.PermissionName.DailyGDriveBackup,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.DailyOneDriveBackup,
            permission_name: PermissionName_1.PermissionName.DailyOneDriveBackup,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.ProPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.FilesMaximumStorageTier,
            permission_name: PermissionName_1.PermissionName.FilesMaximumStorageTier,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.FilesLowStorageTier,
            permission_name: PermissionName_1.PermissionName.FilesLowStorageTier,
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.ProPlan],
            identifier: FeatureIdentifier_1.FeatureIdentifier.SubscriptionSharing,
            permission_name: PermissionName_1.PermissionName.SubscriptionSharing,
        },
    ];
}
exports.serverFeatures = serverFeatures;
