"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.editors = void 0;
const common_1 = require("@standardnotes/common");
const PermissionName_1 = require("../Permission/PermissionName");
const FeatureIdentifier_1 = require("../Feature/FeatureIdentifier");
const NoteType_1 = require("../Component/NoteType");
const FillEditorComponentDefaults_1 = require("./Utilities/FillEditorComponentDefaults");
function editors() {
    const code = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Code',
        spellcheckControl: true,
        identifier: FeatureIdentifier_1.FeatureIdentifier.CodeEditor,
        permission_name: PermissionName_1.PermissionName.CodeEditor,
        note_type: NoteType_1.NoteType.Code,
        file_type: 'txt',
        interchangeable: true,
        index_path: 'index.html',
        description: 'Syntax highlighting and convenient keyboard shortcuts for over 120 programming' +
            ' languages. Ideal for code snippets and procedures.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/code.jpg',
    });
    const plus = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Rich Text',
        note_type: NoteType_1.NoteType.RichText,
        file_type: 'html',
        identifier: FeatureIdentifier_1.FeatureIdentifier.PlusEditor,
        permission_name: PermissionName_1.PermissionName.PlusEditor,
        spellcheckControl: true,
        description: 'From highlighting to custom font sizes and colors, to tables and lists, this editor is perfect for crafting any document.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/plus-editor.jpg',
    });
    const markdown = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Markdown',
        identifier: FeatureIdentifier_1.FeatureIdentifier.MarkdownProEditor,
        note_type: NoteType_1.NoteType.Markdown,
        file_type: 'md',
        permission_name: PermissionName_1.PermissionName.MarkdownProEditor,
        spellcheckControl: true,
        description: 'A fully featured Markdown editor that supports live preview, a styling toolbar, and split pane support.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/adv-markdown.jpg',
    });
    const markdownAlt = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Markdown Alternative',
        identifier: FeatureIdentifier_1.FeatureIdentifier.MarkdownVisualEditor,
        note_type: NoteType_1.NoteType.Markdown,
        file_type: 'md',
        permission_name: PermissionName_1.PermissionName.MarkdownVisualEditor,
        spellcheckControl: true,
        description: 'A WYSIWYG-style Markdown editor that renders Markdown in preview-mode while you type without displaying any syntax.',
        index_path: 'build/index.html',
    });
    const task = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Checklist',
        identifier: FeatureIdentifier_1.FeatureIdentifier.TaskEditor,
        note_type: NoteType_1.NoteType.Task,
        spellcheckControl: true,
        file_type: 'md',
        interchangeable: false,
        permission_name: PermissionName_1.PermissionName.TaskEditor,
        description: 'A great way to manage short-term and long-term to-do"s. You can mark tasks as completed, change their order, and edit the text naturally in place.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/task-editor.jpg',
    });
    const tokenvault = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Authenticator',
        note_type: NoteType_1.NoteType.Authentication,
        file_type: 'json',
        interchangeable: false,
        identifier: FeatureIdentifier_1.FeatureIdentifier.TokenVaultEditor,
        permission_name: PermissionName_1.PermissionName.TokenVaultEditor,
        description: 'Encrypt and protect your 2FA secrets for all your internet accounts. Authenticator handles your 2FA secrets so that you never lose them again, or have to start over when you get a new device.',
        thumbnail_url: 'https://standard-notes.s3.amazonaws.com/screenshots/models/editors/token-vault.png',
    });
    const spreadsheets = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Spreadsheet',
        identifier: FeatureIdentifier_1.FeatureIdentifier.SheetsEditor,
        note_type: NoteType_1.NoteType.Spreadsheet,
        file_type: 'json',
        interchangeable: false,
        permission_name: PermissionName_1.PermissionName.SheetsEditor,
        description: 'A powerful spreadsheet editor with formatting and formula support. Not recommended for large data sets, as encryption of such data may decrease editor performance.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/spreadsheets.png',
    });
    return [code, plus, markdown, markdownAlt, task, tokenvault, spreadsheets];
}
exports.editors = editors;
