"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDeprecatedFeatures = void 0;
const common_1 = require("@standardnotes/common");
const PermissionName_1 = require("../Permission/PermissionName");
const FeatureIdentifier_1 = require("../Feature/FeatureIdentifier");
const NoteType_1 = require("../Component/NoteType");
const FillEditorComponentDefaults_1 = require("./Utilities/FillEditorComponentDefaults");
const ComponentAction_1 = require("../Component/ComponentAction");
const ComponentArea_1 = require("../Component/ComponentArea");
function GetDeprecatedFeatures() {
    const bold = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Alternative Rich Text',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DeprecatedBoldEditor,
        note_type: NoteType_1.NoteType.RichText,
        file_type: 'html',
        component_permissions: [
            {
                name: ComponentAction_1.ComponentAction.StreamContextItem,
                content_types: [common_1.ContentType.Note],
            },
            {
                name: ComponentAction_1.ComponentAction.StreamItems,
                content_types: [
                    common_1.ContentType.FilesafeCredentials,
                    common_1.ContentType.FilesafeFileMetadata,
                    common_1.ContentType.FilesafeIntegration,
                ],
            },
        ],
        spellcheckControl: true,
        deprecated: true,
        permission_name: PermissionName_1.PermissionName.BoldEditor,
        description: 'A simple and peaceful rich editor that helps you write and think clearly.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/bold.jpg',
    });
    const markdownBasic = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Basic Markdown',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DeprecatedMarkdownBasicEditor,
        note_type: NoteType_1.NoteType.Markdown,
        spellcheckControl: true,
        file_type: 'md',
        deprecated: true,
        permission_name: PermissionName_1.PermissionName.MarkdownBasicEditor,
        description: 'A Markdown editor with dynamic split-pane preview.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/simple-markdown.jpg',
    });
    const markdownMinimist = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Minimal Markdown',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DeprecatedMarkdownMinimistEditor,
        note_type: NoteType_1.NoteType.Markdown,
        file_type: 'md',
        index_path: 'index.html',
        permission_name: PermissionName_1.PermissionName.MarkdownMinimistEditor,
        spellcheckControl: true,
        deprecated: true,
        description: 'A minimal Markdown editor with live rendering and in-text search via Ctrl/Cmd + F',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/min-markdown.jpg',
    });
    const markdownMath = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'Markdown with Math',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DeprecatedMarkdownMathEditor,
        spellcheckControl: true,
        permission_name: PermissionName_1.PermissionName.MarkdownMathEditor,
        note_type: NoteType_1.NoteType.Markdown,
        file_type: 'md',
        deprecated: true,
        index_path: 'index.html',
        description: 'A beautiful split-pane Markdown editor with synced-scroll, LaTeX support, and colorful syntax.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/editors/fancy-markdown.jpg',
    });
    const filesafe = (0, FillEditorComponentDefaults_1.FillEditorComponentDefaults)({
        availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
        name: 'FileSafe',
        identifier: FeatureIdentifier_1.FeatureIdentifier.DeprecatedFileSafe,
        component_permissions: [
            {
                name: ComponentAction_1.ComponentAction.StreamContextItem,
                content_types: [common_1.ContentType.Note],
            },
            {
                name: ComponentAction_1.ComponentAction.StreamItems,
                content_types: [
                    common_1.ContentType.FilesafeCredentials,
                    common_1.ContentType.FilesafeFileMetadata,
                    common_1.ContentType.FilesafeIntegration,
                ],
            },
        ],
        permission_name: PermissionName_1.PermissionName.ComponentFilesafe,
        area: ComponentArea_1.ComponentArea.EditorStack,
        deprecated: true,
        description: 'Encrypted attachments for your notes using your Dropbox, Google Drive, or WebDAV server. Limited to 50MB per file.',
        thumbnail_url: 'https://s3.amazonaws.com/standard-notes/screenshots/models/FileSafe-banner.png',
    });
    return [bold, markdownBasic, markdownMinimist, markdownMath, filesafe];
}
exports.GetDeprecatedFeatures = GetDeprecatedFeatures;
