"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clientFeatures = void 0;
const PermissionName_1 = require("../Permission/PermissionName");
const FeatureIdentifier_1 = require("../Feature/FeatureIdentifier");
const common_1 = require("@standardnotes/common");
function clientFeatures() {
    return [
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Tag Nesting',
            identifier: FeatureIdentifier_1.FeatureIdentifier.TagNesting,
            permission_name: PermissionName_1.PermissionName.TagNesting,
            description: 'Organize your tags into folders.',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Smart Filters',
            identifier: FeatureIdentifier_1.FeatureIdentifier.SmartFilters,
            permission_name: PermissionName_1.PermissionName.SmartFilters,
            description: 'Create smart filters for viewing notes matching specific criteria.',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Encrypted files (coming soon)',
            identifier: FeatureIdentifier_1.FeatureIdentifier.Files,
            permission_name: PermissionName_1.PermissionName.Files,
            description: '',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Encrypted files beta',
            identifier: FeatureIdentifier_1.FeatureIdentifier.FilesBeta,
            permission_name: PermissionName_1.PermissionName.FilesBeta,
            description: '',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Focus Mode',
            identifier: FeatureIdentifier_1.FeatureIdentifier.FocusMode,
            permission_name: PermissionName_1.PermissionName.FocusMode,
            description: '',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Listed Custom Domain',
            identifier: FeatureIdentifier_1.FeatureIdentifier.ListedCustomDomain,
            permission_name: PermissionName_1.PermissionName.ListedCustomDomain,
            description: '',
        },
        {
            availableInSubscriptions: [common_1.SubscriptionName.PlusPlan, common_1.SubscriptionName.ProPlan],
            name: 'Multiple accounts',
            identifier: FeatureIdentifier_1.FeatureIdentifier.AccountSwitcher,
            permission_name: PermissionName_1.PermissionName.AccountSwitcher,
            description: '',
        },
    ];
}
exports.clientFeatures = clientFeatures;
