"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindNativeFeature = exports.GetFeaturesForSubscription = exports.GetFeatures = void 0;
const Editors_1 = require("../Lists/Editors");
const Themes_1 = require("../Lists/Themes");
const ServerFeatures_1 = require("../Lists/ServerFeatures");
const ClientFeatures_1 = require("../Lists/ClientFeatures");
const DeprecatedFeatures_1 = require("../Lists/DeprecatedFeatures");
const ExperimentalFeatures_1 = require("../Lists/ExperimentalFeatures");
function GetFeatures() {
    return [
        ...(0, Themes_1.themes)(),
        ...(0, Editors_1.editors)(),
        ...(0, ServerFeatures_1.serverFeatures)(),
        ...(0, ClientFeatures_1.clientFeatures)(),
        ...(0, ExperimentalFeatures_1.experimentalFeatures)(),
        ...(0, DeprecatedFeatures_1.GetDeprecatedFeatures)(),
    ];
}
exports.GetFeatures = GetFeatures;
function GetFeaturesForSubscription(subscription) {
    return GetFeatures().filter((feature) => feature.availableInSubscriptions.includes(subscription));
}
exports.GetFeaturesForSubscription = GetFeaturesForSubscription;
function FindNativeFeature(identifier) {
    return GetFeatures().find((f) => f.identifier === identifier);
}
exports.FindNativeFeature = FindNativeFeature;
