# Component Relay

To get started using the Component Relay, read the [Intro to Extensions guide](https://docs.standardnotes.org/extensions/intro).

## Installation

```
yarn add @standardnotes/component-relay
```

&dash; _or_ &dash;

```
npm install --save @standardnotes/component-relay
```

### Manual

Import the file `dist/dist.js` in your HTML file. For example:

```html
...
<script type="text/javascript" src="dist/dist.js"></script>
...
```

## Tests

The `component-relay` uses [Jest](https://jestjs.io/) for tests. Tests are located in the [test](test) directory. Test files have the following name: `<name>.test.js`.

### Run all tests

Run `yarn test` or `npm test` to run all test suites.

### Coverage

Coverage can be generated by running the `coverage` script.

Then open the [coverage/index.html](coverage/index.html) file in a browser to view it.

## Documentation

Documentation is generated using [Typedoc](https://typedoc.org/). The documentation is available at https://standardnotes.github.io/component-relay/. To update the docs or to view the latest version, run:

```
yarn build:docs
```

This will generate documentation and place it in the `docs/` directory. Create a localhost server using `http-server` and open the [docs/index.html](docs/index.html) file in a browser to view the docs.

To deploy the latest version of the docs to the `gh-pages` branch to publish using [GitHub Pages](https://pages.github.com/), replace `2.0.1` with the latest version and run:

```
yarn deploy-docs -m "build: v2.0.1"
```
