export declare enum ProtocolVersion {
    V001 = "001",
    V002 = "002",
    V003 = "003",
    V004 = "004"
}
export declare const ProtocolVersionLatest = ProtocolVersion.V004;
/** The last protocol version to not use root-key based items keys */
export declare const ProtocolVersionLastNonrootItemsKey = ProtocolVersion.V003;
export declare const ProtocolExpirationDates: Partial<Record<ProtocolVersion, number>>;
export declare function isProtocolVersionExpired(version: ProtocolVersion): boolean;
export declare const ProtocolVersionLength = 3;
export declare function protocolVersionFromEncryptedString(string: string): ProtocolVersion;
/**
 *  -1 if a < b
 *  0 if a == b
 *  1 if a > b
 */
export declare function compareVersions(a: ProtocolVersion, b: ProtocolVersion): number;
export declare function leftVersionGreaterThanOrEqualToRight(a: ProtocolVersion, b: ProtocolVersion): boolean;
export declare function isVersionLessThanOrEqualTo(input: ProtocolVersion, compareTo: ProtocolVersion): boolean;
//# sourceMappingURL=ProtocolVersion.d.ts.map