var SKAlert = /** @class */ (function () {
    function SKAlert(_a) {
        var title = _a.title, text = _a.text, buttons = _a.buttons;
        this.title = title;
        this.text = text;
        this.buttons = buttons || [];
    }
    SKAlert.prototype.buttonsString = function () {
        var genButton = function (buttonDesc, index) {
            return "\n        <button id='button-".concat(index, "' class='font-bold px-2.5 py-2 text-xs text-info-contrast bg-").concat(buttonDesc.style, "'>\n          <div class='sk-label'>").concat(buttonDesc.text, "</div>\n        </button>\n      ");
        };
        var buttonString = this.buttons
            .map(function (buttonDesc, index) {
            return genButton(buttonDesc, index);
        })
            .join('');
        var str = "\n      <div class='sk-button-group'>\n        ".concat(buttonString, "\n      </div>\n    ");
        return str;
    };
    SKAlert.prototype.templateString = function () {
        var buttonsTemplate;
        var panelStyle;
        if (this.buttons) {
            buttonsTemplate = "\n        <div class=\"sk-panel-row\" style='margin-top: 8px;'>\n          ".concat(this.buttonsString(), "\n        </div>\n      ");
            panelStyle = '';
        }
        else {
            buttonsTemplate = '';
            panelStyle = 'style="padding-bottom: 8px"';
        }
        var titleTemplate = this.title ? "<div class='sk-h3 sk-panel-section-title'>".concat(this.title, "</div>") : '';
        var messageTemplate = this.text ? "<p class='sk-p'>".concat(this.text, "</p>") : '';
        var template = "\n      <div class=\"sk-modal\">\n        <div class=\"sk-modal-background\"></div>\n        <div class=\"sk-modal-content\">\n          <div class=\"sn-component\">\n            <div class=\"sk-panel\" style='max-width: 500px;'>\n              <div class=\"sk-panel-content\" ".concat(panelStyle, ">\n                <div class=\"sk-panel-section\">\n                  ").concat(titleTemplate, "\n\n                  <div class=\"sk-panel-row\">\n                    ").concat(messageTemplate, "\n                  </div>\n\n                  ").concat(buttonsTemplate, "\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ");
        return template;
    };
    SKAlert.prototype.dismiss = function () {
        this.onElement.removeChild(this.element);
    };
    SKAlert.prototype.primaryButton = function () {
        var primary = this.buttons.find(function (button) { return button.primary === true; });
        if (!primary) {
            primary = this.buttons[this.buttons.length - 1];
        }
        return primary;
    };
    SKAlert.prototype.present = function (onElement) {
        var _this = this;
        if (!onElement) {
            onElement = document.body;
        }
        this.onElement = onElement;
        this.element = document.createElement('div');
        this.element.className = 'sn-component';
        this.element.innerHTML = this.templateString().trim();
        onElement.appendChild(this.element);
        if (this.buttons && this.buttons.length) {
            this.buttons.forEach(function (buttonDesc, index) {
                var buttonElem = _this.element.querySelector("#button-".concat(index));
                buttonElem.onclick = function () {
                    buttonDesc.action && buttonDesc.action();
                    _this.dismiss();
                };
                if (index === 0) {
                    buttonElem.focus();
                }
            });
        }
    };
    return SKAlert;
}());
export { SKAlert };
