declare type AlertButtonStyle = 'small' | 'outlined' | 'contrast' | 'neutral' | 'info' | 'warning' | 'danger' | 'success';
declare type AlertButton = {
    text: string;
    style: AlertButtonStyle;
    action: () => void;
    primary?: boolean;
};
export declare class SKAlert {
    private title?;
    private text;
    private buttons;
    private element;
    private onElement;
    constructor({ title, text, buttons }: {
        title?: string;
        text: string;
        buttons?: AlertButton[];
    });
    buttonsString(): string;
    templateString(): string;
    dismiss(): void;
    primaryButton(): AlertButton;
    present(onElement?: HTMLElement): void;
}
export {};
