"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("reflect-metadata");
const jsonwebtoken_1 = require("jsonwebtoken");
const TokenEncoder_1 = require("./TokenEncoder");
describe('TokenEncoder', () => {
    const jwtSecret = 'secret';
    const createEncoder = () => new TokenEncoder_1.TokenEncoder(jwtSecret);
    it('should encode a token', () => {
        const encodedToken = createEncoder().encodeToken({ user_uuid: '123' });
        expect((0, jsonwebtoken_1.verify)(encodedToken, jwtSecret).user_uuid).toEqual('123');
        expect((0, jsonwebtoken_1.verify)(encodedToken, jwtSecret).exp).toBeUndefined();
    });
    it('should encode an expirable token', () => {
        const encodedToken = createEncoder().encodeExpirableToken({ user_uuid: '123' }, 123);
        expect((0, jsonwebtoken_1.verify)(encodedToken, jwtSecret).user_uuid).toEqual('123');
        expect((0, jsonwebtoken_1.verify)(encodedToken, jwtSecret).exp).toBeGreaterThan(0);
    });
});
