/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import { getExtensionDependencyFromEditor } from '@lexical/extension';
import { useLexicalComposerContext } from '@lexical/react/LexicalComposerContext';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
function useExtensionDependency(extension) {
  return getExtensionDependencyFromEditor(useLexicalComposerContext()[0], extension);
}

/**
 * Use a Component from the given Extension that uses the ReactExtension convention
 * of exposing a Component property in its output.
 *
 * @param extension - An extension with a Component property in the output
 * @returns `getExtensionConfigFromEditor(useLexicalComposerContext()[0], extension).Component`
 */
function useExtensionComponent(extension) {
  return useExtensionDependency(extension).output.Component;
}

export { useExtensionComponent, useExtensionDependency };
