/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var extension = require('@lexical/extension');
var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
function useExtensionDependency(extension$1) {
  return extension.getExtensionDependencyFromEditor(LexicalComposerContext.useLexicalComposerContext()[0], extension$1);
}

/**
 * Use a Component from the given Extension that uses the ReactExtension convention
 * of exposing a Component property in its output.
 *
 * @param extension - An extension with a Component property in the output
 * @returns `getExtensionConfigFromEditor(useLexicalComposerContext()[0], extension).Component`
 */
function useExtensionComponent(extension) {
  return useExtensionDependency(extension).output.Component;
}

exports.useExtensionComponent = useExtensionComponent;
exports.useExtensionDependency = useExtensionDependency;
