import { type AnyLexicalExtension, type LexicalExtensionDependency, type OutputComponentExtension } from 'lexical';
export declare function useExtensionDependency<Extension extends AnyLexicalExtension>(extension: Extension): LexicalExtensionDependency<Extension>;
/**
 * Use a Component from the given Extension that uses the ReactExtension convention
 * of exposing a Component property in its output.
 *
 * @param extension - An extension with a Component property in the output
 * @returns `getExtensionConfigFromEditor(useLexicalComposerContext()[0], extension).Component`
 */
export declare function useExtensionComponent<Props extends Record<never, never>, OutputComponent extends React.ComponentType<Props>, Extension extends OutputComponentExtension<OutputComponent>>(extension: Extension): OutputComponent;
