/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { BaseBinding, Binding, BindingV2, ExcludedProperties, Provider, SyncCursorPositionsFn } from '@lexical/yjs';
import type { LexicalEditor } from 'lexical';
import type { JSX } from 'react';
import * as React from 'react';
import { Doc } from 'yjs';
import { InitialEditorStateType } from '../LexicalComposer';
export type CursorsContainerRef = React.RefObject<HTMLElement | null>;
export declare function useYjsCollaboration(editor: LexicalEditor, id: string, provider: Provider, docMap: Map<string, Doc>, name: string, color: string, shouldBootstrap: boolean, binding: Binding, setDoc: React.Dispatch<React.SetStateAction<Doc | undefined>>, cursorsContainerRef?: CursorsContainerRef, initialEditorState?: InitialEditorStateType, awarenessData?: object, syncCursorPositionsFn?: SyncCursorPositionsFn): JSX.Element;
export declare function useYjsCollaborationV2__EXPERIMENTAL(editor: LexicalEditor, id: string, doc: Doc, provider: Provider, docMap: Map<string, Doc>, name: string, color: string, options?: {
    awarenessData?: object;
    excludedProperties?: ExcludedProperties;
    rootName?: string;
    __shouldBootstrapUnsafe?: boolean;
}): BindingV2;
export declare function useYjsCursors(binding: BaseBinding, cursorsContainerRef?: CursorsContainerRef): JSX.Element;
export declare function useYjsFocusTracking(editor: LexicalEditor, provider: Provider, name: string, color: string, awarenessData?: object): void;
export declare function useYjsHistory(editor: LexicalEditor, binding: Binding): () => void;
export declare function useYjsHistoryV2(editor: LexicalEditor, binding: BindingV2): () => void;
