/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { JSX } from 'react';
import { type LexicalEditor } from 'lexical';
import { type ErrorBoundaryType } from './useDecorators';
export { type ErrorBoundaryType };
/**
 * @internal
 *
 * When using @lexical/extension, the ReactProvider is expected to handle
 * rendering decorators. This component allows RichTextPlugin and
 * PlainTextPlugin to be used in extension projects that have not yet
 * migrated to use RichTextExtension or PlainTextExtension.
 **/
export declare function LegacyDecorators({ editor, ErrorBoundary, }: {
    editor: LexicalEditor;
    ErrorBoundary: ErrorBoundaryType;
}): JSX.Element | null;
