/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { JSX } from 'react';
import { TreeView } from '@lexical/react/LexicalTreeView';
export type TreeViewConfig = Omit<Parameters<typeof TreeView>[0], 'editor'>;
export declare function TreeViewExtensionComponent(props: Partial<TreeViewConfig>): JSX.Element;
/**
 * Provides a configured TreeView debugging tool (React dependent)
 * as an output component with configurable class names.
 */
export declare const TreeViewExtension: import("lexical").LexicalExtension<TreeViewConfig, "@lexical/react/TreeView", {
    Component: typeof TreeViewExtensionComponent;
}, unknown>;
