/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { DecoratorComponentProps } from './shared/types';
import type { JSX } from 'react';
import { type AnyLexicalExtension, type LexicalEditor, type LexicalExtensionOutput } from 'lexical';
import * as React from 'react';
import { type Container, type Root } from 'react-dom/client';
export type { DecoratorComponentProps };
export interface HostMountCommandArg {
    root: Root;
}
export interface MountPluginCommandArg {
    key: string;
    element: JSX.Element | null;
    domNode?: Element | DocumentFragment | null;
}
export declare function mountReactExtensionComponent<Extension extends AnyLexicalExtension>(editor: LexicalEditor, opts: {
    extension: Extension;
    props: [LexicalExtensionOutput<Extension>] extends [
        {
            Component: infer OutputComponentType extends React.ComponentType;
        }
    ] ? /** The Props from the Extension output Component */ React.ComponentProps<OutputComponentType> | null : never;
} & Omit<MountPluginCommandArg, 'element'>): void;
export declare function mountReactPluginComponent<P extends Record<never, never> = Record<never, never>>(editor: LexicalEditor, opts: {
    Component: React.ComponentType<P>;
    props: (P & React.Attributes) | null;
} & Omit<MountPluginCommandArg, 'element'>): void;
export declare function mountReactPluginElement(editor: LexicalEditor, opts: MountPluginCommandArg): void;
export declare function mountReactPluginHost(editor: LexicalEditor, container: Container): void;
export declare const REACT_PLUGIN_HOST_MOUNT_ROOT_COMMAND: import("lexical").LexicalCommand<HostMountCommandArg>;
export declare const REACT_PLUGIN_HOST_MOUNT_PLUGIN_COMMAND: import("lexical").LexicalCommand<MountPluginCommandArg>;
/**
 * This extension provides a React host for editors that are not built
 * with LexicalExtensionComposer (e.g. you are using Vanilla JS or some
 * other framework).
 *
 * You must use {@link mountReactPluginHost} for any React content to work.
 * Afterwards, you may use {@link mountReactExtensionComponent} to
 * render UI for a specific React Extension.
 * {@link mountReactPluginComponent} and
 * {@link mountReactPluginElement} can be used to render
 * legacy React plug-ins (or any React content).
 */
export declare const ReactPluginHostExtension: import("lexical").LexicalExtension<import("lexical").ExtensionConfigBase, "@lexical/react/ReactPluginHost", {
    mountReactPlugin: (arg: MountPluginCommandArg) => void;
    mountReactPluginHost: (container: Container) => boolean;
    mountedPluginsStore: import("@preact/signals-core").Signal<{
        plugins: Map<string, MountPluginCommandArg>;
    }>;
}, unknown>;
