/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { EditorChildrenComponentProps, ReactConfig, ReactOutputs } from './shared/types';
import type { LexicalComposerContextWithEditor } from '@lexical/react/LexicalComposerContext';
export type { EditorChildrenComponentProps, ReactConfig, ReactOutputs };
/**
 * @example
 * The default EditorChildrenComponent implementation
 * ```jsx
 * return (
 *   <>
 *     {contentEditable}
 *     {children}
 *   </>
 * );
 * ```
 */
export declare function DefaultEditorChildrenComponent({ contentEditable, children, }: EditorChildrenComponentProps): import("react/jsx-runtime").JSX.Element;
/**
 * An extension to use or configure React for use with Lexical. In an editor, you
 * would typically use {@link LexicalExtensionComposer} (for React projects) or
 * {@link ReactPluginHostExtension} (to use React Extensions and plug-ins in a non-React
 * project).
 *
 * See {@link ReactConfig} for more detailed exextensionations of how to use
 * the config for this Extension.
 *
 * For an Extension developer, you can defineConfig() override the extension with
 * decorators to add JSX inside the editor context that is not
 * location-dependent (e.g. floating UI that does not need to be mounted in
 * some specific location, or effects that return null).
 */
export declare const ReactExtension: import("lexical").LexicalExtension<ReactConfig, "@lexical/react/React", {
    Component: (props: Partial<import("./shared/types").EditorComponentProps>) => import("react/jsx-runtime").JSX.Element;
    context: LexicalComposerContextWithEditor;
}, unknown>;
