/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import { useLexicalComposerContext } from '@lexical/react/LexicalComposerContext';
import { TreeView } from '@lexical/react/LexicalTreeView';
import { ReactExtension } from '@lexical/react/ReactExtension';
import { useExtensionDependency } from '@lexical/react/useExtensionComponent';
import { defineExtension } from 'lexical';
import { jsx } from 'react/jsx-runtime';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function TreeViewExtensionComponent(props) {
  const [editor] = useLexicalComposerContext();
  return /*#__PURE__*/jsx(TreeView, {
    editor: editor,
    ...useExtensionDependency(TreeViewExtension).config,
    ...props
  });
}
const config = {
  timeTravelButtonClassName: 'debug-timetravel-button',
  timeTravelPanelButtonClassName: 'debug-timetravel-panel-button',
  timeTravelPanelClassName: 'debug-timetravel-panel',
  timeTravelPanelSliderClassName: 'debug-timetravel-panel-slider',
  treeTypeButtonClassName: 'debug-treetype-button',
  viewClassName: 'tree-view-output'
};

/**
 * Provides a configured TreeView debugging tool (React dependent)
 * as an output component with configurable class names.
 */
const TreeViewExtension = defineExtension({
  build: () => ({
    Component: TreeViewExtensionComponent
  }),
  config,
  dependencies: [ReactExtension],
  name: '@lexical/react/TreeView'
});

export { TreeViewExtension, TreeViewExtensionComponent };
