/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var LexicalTreeView = require('@lexical/react/LexicalTreeView');
var ReactExtension = require('@lexical/react/ReactExtension');
var useExtensionComponent = require('@lexical/react/useExtensionComponent');
var lexical = require('lexical');
var jsxRuntime = require('react/jsx-runtime');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function TreeViewExtensionComponent(props) {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  return /*#__PURE__*/jsxRuntime.jsx(LexicalTreeView.TreeView, {
    editor: editor,
    ...useExtensionComponent.useExtensionDependency(TreeViewExtension).config,
    ...props
  });
}
const config = {
  timeTravelButtonClassName: 'debug-timetravel-button',
  timeTravelPanelButtonClassName: 'debug-timetravel-panel-button',
  timeTravelPanelClassName: 'debug-timetravel-panel',
  timeTravelPanelSliderClassName: 'debug-timetravel-panel-slider',
  treeTypeButtonClassName: 'debug-treetype-button',
  viewClassName: 'tree-view-output'
};

/**
 * Provides a configured TreeView debugging tool (React dependent)
 * as an output component with configurable class names.
 */
const TreeViewExtension = lexical.defineExtension({
  build: () => ({
    Component: TreeViewExtensionComponent
  }),
  config,
  dependencies: [ReactExtension.ReactExtension],
  name: '@lexical/react/TreeView'
});

exports.TreeViewExtension = TreeViewExtension;
exports.TreeViewExtensionComponent = TreeViewExtensionComponent;
