/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import { LexicalNode } from 'lexical';
import { JSX, RefObject } from 'react';
declare class MenuOption {
    key: string;
    ref?: RefObject<HTMLElement | null>;
    constructor(key: string);
    setRefElement(element: HTMLElement | null): void;
}
declare class NodeContextMenuOption extends MenuOption {
    type: string;
    title: string;
    icon: JSX.Element | null;
    disabled: boolean;
    $onSelect: () => void;
    $showOn?: (node: LexicalNode) => boolean;
    constructor(title: string, options: {
        disabled?: boolean;
        icon?: JSX.Element;
        $onSelect: () => void;
        $showOn?: (node: LexicalNode) => boolean;
    });
}
declare class NodeContextMenuSeparator extends MenuOption {
    type: string;
    $showOn?: (node: LexicalNode) => boolean;
    constructor(options?: {
        $showOn?: (node: LexicalNode) => boolean;
    });
}
type ContextMenuType = NodeContextMenuOption | NodeContextMenuSeparator;
interface Props {
    label?: string;
    nested?: boolean;
    itemClassName?: string;
    separatorClassName?: string;
    items: ContextMenuType[];
}
declare const NodeContextMenuPlugin: import("react").ForwardRefExoticComponent<Omit<Props & import("react").HTMLProps<HTMLButtonElement>, "ref"> & import("react").RefAttributes<HTMLButtonElement>>;
export { NodeContextMenuOption, NodeContextMenuPlugin, NodeContextMenuSeparator };
