/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var extension = require('@lexical/extension');
var link = require('@lexical/link');
var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var react = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function LinkPlugin({
  validateUrl,
  attributes
}) {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  react.useEffect(() => {
    if (!editor.hasNodes([link.LinkNode])) {
      throw new Error('LinkPlugin: LinkNode not registered on editor');
    }
  });
  react.useEffect(() => {
    return link.registerLink(editor, extension.namedSignals({
      attributes,
      validateUrl
    }));
  }, [editor, validateUrl, attributes]);
  return null;
}

exports.LinkPlugin = LinkPlugin;
