/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var hashtag = require('@lexical/hashtag');
var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var react = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function HashtagPlugin() {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  react.useEffect(() => {
    if (!editor.hasNodes([hashtag.HashtagNode])) {
      throw new Error('HashtagPlugin: HashtagNode not registered on editor');
    }
    return hashtag.registerLexicalHashtag(editor);
  }, [editor]);
  return null;
}

exports.HashtagPlugin = HashtagPlugin;
