/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var useExtensionComponent = require('@lexical/react/useExtensionComponent');
var jsxRuntime = require('react/jsx-runtime');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

/**
 * A convenient way to get an Extension's output Component with {@link useExtensionComponent}
 * and construct it in one step.
 *
 * @example
 * Usage
 * ```tsx
 * return (
 *   <ExtensionComponent
 *     lexical:extension={TreeViewExtension}
 *     viewClassName="tree-view-output" />
 * );
 * ```
 *
 * @example
 * Alternative without ExtensionComponent
 * ```tsx
 * const TreeViewComponent = useExtensionComponent(TreeViewExtension);
 * return (<TreeViewComponent viewClassName="tree-view-output" />);
 * ```
 */
function ExtensionComponent({
  'lexical:extension': extension,
  ...props
}) {
  const Component = useExtensionComponent.useExtensionComponent(extension);
  return /*#__PURE__*/jsxRuntime.jsx(Component, {
    ...props
  });
}

exports.ExtensionComponent = ExtensionComponent;
