/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import { ErrorBoundary } from 'react-error-boundary';
import { jsx } from 'react/jsx-runtime';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function LexicalErrorBoundary({
  children,
  onError
}) {
  return /*#__PURE__*/jsx(ErrorBoundary, {
    fallback: /*#__PURE__*/jsx("div", {
      style: {
        border: '1px solid #f00',
        color: '#f00',
        padding: '8px'
      },
      children: "An error was thrown."
    }),
    onError: onError,
    children: children
  });
}

export { LexicalErrorBoundary };
