/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { JSX } from 'react';
import { ExcludedProperties, Provider, SyncCursorPositionsFn } from '@lexical/yjs';
import { Doc } from 'yjs';
import { InitialEditorStateType } from './LexicalComposer';
import { CursorsContainerRef } from './shared/useYjsCollaboration';
type ProviderFactory = (id: string, yjsDocMap: Map<string, Doc>) => Provider;
type CollaborationPluginProps = {
    id: string;
    providerFactory: ProviderFactory;
    shouldBootstrap: boolean;
    username?: string;
    cursorColor?: string;
    cursorsContainerRef?: CursorsContainerRef;
    initialEditorState?: InitialEditorStateType;
    excludedProperties?: ExcludedProperties;
    awarenessData?: object;
    syncCursorPositionsFn?: SyncCursorPositionsFn;
};
export declare function CollaborationPlugin({ id, providerFactory, shouldBootstrap, username, cursorColor, cursorsContainerRef, initialEditorState, excludedProperties, awarenessData, syncCursorPositionsFn, }: CollaborationPluginProps): JSX.Element;
type CollaborationPluginV2Props = {
    id: string;
    doc: Doc;
    provider: Provider;
    __shouldBootstrapUnsafe?: boolean;
    username?: string;
    cursorColor?: string;
    cursorsContainerRef?: CursorsContainerRef;
    excludedProperties?: ExcludedProperties;
    awarenessData?: object;
};
export declare function CollaborationPluginV2__EXPERIMENTAL({ id, doc, provider, __shouldBootstrapUnsafe, username, cursorColor, cursorsContainerRef, excludedProperties, awarenessData, }: CollaborationPluginV2Props): JSX.Element;
export {};
