/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import { AutoLinkNode, registerAutoLink } from '@lexical/link';
export { createLinkMatcherWithRegExp } from '@lexical/link';
import { useLexicalComposerContext } from '@lexical/react/LexicalComposerContext';
import { useEffect } from 'react';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

// Do not require this module directly! Use normal `invariant` calls.

function formatDevErrorMessage(message) {
  throw new Error(message);
}

function useAutoLink(editor, matchers, onChange) {
  useEffect(() => {
    if (!editor.hasNodes([AutoLinkNode])) {
      {
        formatDevErrorMessage(`LexicalAutoLinkPlugin: AutoLinkNode not registered on editor`);
      }
    }
  });
  useEffect(() => {
    return registerAutoLink(editor, {
      changeHandlers: onChange ? [onChange] : [],
      matchers
    });
  }, [editor, matchers, onChange]);
}
function AutoLinkPlugin({
  matchers,
  onChange
}) {
  const [editor] = useLexicalComposerContext();
  useAutoLink(editor, matchers, onChange);
  return null;
}

export { AutoLinkPlugin };
