/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

'use strict';

var link = require('@lexical/link');
var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var react = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

// Do not require this module directly! Use normal `invariant` calls.

function formatDevErrorMessage(message) {
  throw new Error(message);
}

function useAutoLink(editor, matchers, onChange) {
  react.useEffect(() => {
    if (!editor.hasNodes([link.AutoLinkNode])) {
      {
        formatDevErrorMessage(`LexicalAutoLinkPlugin: AutoLinkNode not registered on editor`);
      }
    }
  });
  react.useEffect(() => {
    return link.registerAutoLink(editor, {
      changeHandlers: onChange ? [onChange] : [],
      matchers
    });
  }, [editor, matchers, onChange]);
}
function AutoLinkPlugin({
  matchers,
  onChange
}) {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  useAutoLink(editor, matchers, onChange);
  return null;
}

exports.createLinkMatcherWithRegExp = link.createLinkMatcherWithRegExp;
exports.AutoLinkPlugin = AutoLinkPlugin;
