/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { EditorConfig, LexicalNode, RangeSelection, SerializedElementNode } from 'lexical';
import { ElementNode } from 'lexical';
export type SerializedOverflowNode = SerializedElementNode;
/** @noInheritDoc */
export declare class OverflowNode extends ElementNode {
    /** @internal */
    $config(): import("lexical").StaticNodeConfigRecord<"overflow", {
        $transform(node: OverflowNode): void;
        extends: typeof ElementNode;
    }>;
    createDOM(config: EditorConfig): HTMLElement;
    updateDOM(prevNode: this, dom: HTMLElement): boolean;
    insertNewAfter(selection: RangeSelection, restoreSelection?: boolean): null | LexicalNode;
    excludeFromCopy(): boolean;
}
export declare function $createOverflowNode(): OverflowNode;
export declare function $isOverflowNode(node: LexicalNode | null | undefined): node is OverflowNode;
/**
 * Configures {@link OverflowNode}
 */
export declare const OverflowExtension: import("lexical").LexicalExtension<import("lexical").ExtensionConfigBase, "@lexical/overflow", unknown, unknown>;
