/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
/**
 * Call the given synchronous function with a window object,
 * either from the browser or happy-dom in a non-browser
 * environment. It will also set window, document, and MutationObserver
 * on globalThis while the callback is running. This is
 * useful primarily to parse and render HTML server-side.
 *
 * It is not safe to do anything asynchronous during this callback.
 *
 * @param f A function that uses the window object
 * @returns The result of that function.
 */
export declare function withDOM<T>(f: (window: typeof globalThis.window) => T): T;
