/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import { LexicalEditor } from 'lexical';
/** @internal */
declare const defaultHashtagConfig: HashtagConfig;
/** @internal */
export declare function registerLexicalHashtag(editor: LexicalEditor, config?: typeof defaultHashtagConfig): () => void;
export interface HashtagConfig {
    /**
     * The matching function used by the extension. Has a default
     * implementation that should be suitable for most use cases.
     *
     * @param text The string of text to match
     * @returns `null` if no match, otherwise an object with the start and end index of the first `#hashtag` match
     */
    getHashtagMatch: (text: string) => null | {
        start: number;
        end: number;
    };
}
/**
 * Add `#hashtag` support to the editor
 */
export declare const HashtagExtension: import("lexical").LexicalExtension<HashtagConfig, "@lexical/hashtag/Hashtag", unknown, unknown>;
export {};
