import { Command, CommandType, Package, PackageGraphNode, ProjectConfig, VersionCommandOption } from '@lerna-lite/core';
import { ReleaseClient, ReleaseNote, RemoteCommit } from './models';
export declare function factory(argv: VersionCommandOption): VersionCommand;
export declare class VersionCommand extends Command<VersionCommandOption> {
    /** command name */
    name: CommandType;
    globalVersion: string;
    changelogIncludeCommitsClientLogin?: boolean | string;
    changelogIncludeCommitsGitAuthor?: boolean | string;
    commitsSinceLastRelease?: RemoteCommit[];
    packagesToVersion: Package[];
    updatesVersions?: Map<string, string>;
    currentBranch: string;
    gitRemote: string;
    tagPrefix: string;
    commitAndTag: boolean;
    pushToRemote: boolean;
    hasRootedLeaf: boolean;
    releaseClient?: ReleaseClient;
    releaseNotes: ReleaseNote[];
    gitOpts: any;
    runPackageLifecycle: any;
    runRootLifecycle: (stage: string) => Promise<void> | void;
    savePrefix: string;
    tags: string[];
    updates: PackageGraphNode[];
    get otherCommandConfigs(): string[];
    get requiresGit(): boolean;
    constructor(argv: VersionCommandOption | ProjectConfig);
    configureProperties(): void;
    initialize(): Promise<boolean>;
    execute(): Promise<{
        updates: PackageGraphNode[];
        updatesVersions: Map<string, string> | undefined;
    }>;
    getVersionsForUpdates(): Promise<Map<string, string>>;
    reduceVersions(getVersion: (s: PackageGraphNode) => string): Promise<Map<string, string>>;
    setUpdatesForVersions(versions: Map<string, string>): void;
    getPrereleasePackageNames(): string[];
    /**
     * @param {boolean|string|string[]} option
     * @returns {Set<string>} A set of package names (or wildcard) derived from option value.
     */
    getPackagesForOption(option?: boolean | string | string[]): Set<string>;
    recommendVersions(resolvePrereleaseId: any): Promise<Map<string, string>>;
    confirmVersions(): Promise<boolean> | boolean;
    updatePackageVersions(): Promise<any>;
    commitAndTagUpdates(): Promise<void>;
    gitCommitAndTagVersionForUpdates(): Promise<string[]>;
    gitCommitAndTagVersion(): Promise<string[]>;
    gitPushToRemote(): Promise<void>;
    setGlobalVersionFloor(): void;
    setGlobalVersionCeiling(versions: Map<string, string>): string;
}
