"use strict";
/**
 * All credit to https://github.com/sindresorhus/temp-write/blob/199851974c8af0618e2f1a77023384823f2ae948/index.js
 *
 * Embedded here into lerna directly because we cannot yet migrate to ESM only, and we needed to bump outdated deps.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tempWrite = void 0;
const tslib_1 = require("tslib");
const graceful_fs_1 = tslib_1.__importDefault(require("graceful-fs"));
const is_stream_1 = tslib_1.__importDefault(require("is-stream"));
const make_dir_1 = tslib_1.__importDefault(require("make-dir"));
const path_1 = tslib_1.__importDefault(require("path"));
const temp_dir_1 = tslib_1.__importDefault(require("temp-dir"));
const util_1 = require("util");
const uuid_1 = require("uuid");
const writeFileP = (0, util_1.promisify)(graceful_fs_1.default.writeFile);
const tempfile = (filePath) => path_1.default.join(temp_dir_1.default, `lerna-${(0, uuid_1.v4)()}`, filePath || '');
const writeStream = async (filePath, fileContent) => new Promise((resolve, reject) => {
    const writable = graceful_fs_1.default.createWriteStream(filePath);
    fileContent
        .on('error', (error) => {
        // Be careful to reject before writable.end(), otherwise the writable's
        // 'finish' event will fire first and we will resolve the promise
        // before we reject it.
        reject(error);
        fileContent.unpipe(writable);
        writable.end();
    })
        .pipe(writable)
        .on('error', reject)
        .on('finish', resolve);
});
async function tempWrite(fileContent, filePath) {
    const tempPath = tempfile(filePath);
    const write = (0, is_stream_1.default)(fileContent) ? writeStream : writeFileP;
    await (0, make_dir_1.default)(path_1.default.dirname(tempPath));
    await write(tempPath, fileContent);
    return tempPath;
}
exports.tempWrite = tempWrite;
tempWrite.sync = (fileContent, filePath) => {
    const tempPath = tempfile(filePath);
    make_dir_1.default.sync(path_1.default.dirname(tempPath));
    graceful_fs_1.default.writeFileSync(tempPath, fileContent);
    return tempPath;
};
//# sourceMappingURL=temp-write.js.map