import { Package } from '@lerna-lite/core';
/**
 * From a folder path provided, try to load a `package-lock.json` file if it exists.
 * @param {String} lockFileFolderPath
 * @returns Promise<{path: string; json: Object; lockFileVersion: number; }>
 */
export declare function loadPackageLockFileWhenExists<T = any>(lockFileFolderPath: string): Promise<{
    path: string;
    json: Awaited<T>;
    lockfileVersion: number;
} | undefined>;
/**
 * Update NPM Lock File (when found), the lock file might be version 1 (exist in package folder) or version 2 (exist in workspace root)
 * Depending on the version type, the structure of the lock file will be different and will be updated accordingly
 * @param {Object} pkg
 * @returns Promise<string>
 */
export declare function updateClassicLockfileVersion(pkg: Package): Promise<string | undefined>;
/**
 * Update NPM Lock File (when found), the lock file must be version 2 or higher and is considered as modern lockfile,
 * its structure is different and all version properties will be updated accordingly
 * @param {Object} pkg
 * @param {Object} project
 * @returns Promise<string>
 */
export declare function updateTempModernLockfileVersion(pkg: Package, projLockFileObj: any): void;
/**
 * Save a lockfile by providing a full path and an updated json object
 * @param {String} filePath
 * @param {Object} updateLockFileObj
 * @returns Promise<String | undefined> - file path will be returned when it was found and updated
 */
export declare function saveUpdatedLockJsonFile(filePath: string, updateLockFileObj: any): Promise<string | undefined>;
/**
 * Update workspace root NPM Lock File Version Type 2 (considerd modern lockfile)
 * @param {Object} obj
 * @param {String} pkgName
 * @param {String} newVersion
 */
export declare function updateNpmLockFileVersion2(obj: any, pkgName: string, newVersion: string): void;
/**
 * Run `npm install --package-lock-only` or equivalent depending on the package manager defined in `npmClient`
 * @param {'npm' | 'pnpm' | 'yarn'} npmClient
 * @param {String} cwd
 * @returns {Promise<string | undefined>} lockfile name if executed successfully
 */
export declare function runInstallLockFileOnly(npmClient: 'npm' | 'pnpm' | 'yarn', cwd: string, npmArgs: string[]): Promise<string | undefined>;
/**
 * Simply validates if a file exists
 * @param {String} filePath - file path
 * @returns {Boolean}
 */
export declare function validateFileExists(filePath: string): Promise<boolean>;
