"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.remoteBranchExists = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
/**
 * @param {string} gitRemote
 * @param {string} branch
 * @param {import('@lerna/child-process').ExecOpts} opts
 */
function remoteBranchExists(gitRemote, branch, opts, dryRun = false) {
    npmlog_1.default.silly('remoteBranchExists', '');
    const remoteBranch = `${gitRemote}/${branch}`;
    try {
        (0, core_1.execSync)('git', ['show-ref', '--verify', `refs/remotes/${remoteBranch}`], opts, dryRun);
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.remoteBranchExists = remoteBranchExists;
//# sourceMappingURL=remote-branch-exists.js.map