import { PackageGraphNode } from '@lerna-lite/core';
/**
 * @param {(existingPreid: string) => string} resolvePrereleaseId
 * @param {string} buildMetadata
 */
export declare function makePromptVersion(resolvePrereleaseId: (prereleaseId?: string) => string | undefined, buildMetadata?: string): (node: PackageGraphNode) => Promise<string>;
/**
 * A predicate that prompts user to select/construct a version bump.
 * It can be run per-package (independent) or globally (fixed).
 *
 * @param {PackageGraphNode|Object} node The metadata to process
 * @param {String} currentVersion
 * @param {String} name (Only used in independent mode)
 * @param {String} prereleaseId
 * @param {String} buildMetadata
 */
export declare function promptVersion(currentVersion: string, name: string, prereleaseId?: string, buildMetadata?: string): Promise<string>;
